#include "mainwindow.h"
#include "ui_mainwindow.h"

MainWindow *g_pMainwindow;

QRETURN on_process_signal_removed( PVOID pDevice, ULONG nVideoInput, ULONG nAudioInput, PVOID pUserData )
{
    ULONG i = (uintptr_t)(pUserData);

    qDebug("signal removed \n");

    g_pMainwindow->m_str_info[ i ].sprintf("INFO : No signal detected");

    return QCAP_RT_OK;
}

QRETURN on_process_no_signal_detected( PVOID pDevice, ULONG nVideoInput, ULONG nAudioInput, PVOID pUserData )
{
    ULONG i = (uintptr_t)(pUserData);

    qDebug("no signal Detected \n");

    g_pMainwindow->m_str_info[ i ].sprintf("INFO : No signal detected");

    return QCAP_RT_OK;
}

QRETURN on_process_format_changed( PVOID pDevice, ULONG nVideoInput, ULONG nAudioInput, ULONG nVideoWidth, ULONG nVideoHeight, BOOL bVideoIsInterleaved, double dVideoFrameRate, ULONG nAudioChannels, ULONG nAudioBitsPerSample,  ULONG nAudioSampleFrequency, PVOID pUserData )
{
    ULONG i = (uintptr_t)(pUserData);

    UINT nVH = 0;

    CHAR strVideoInput[ 64 ] = { 0 };

    CHAR strAudioInput[ 64 ] = { 0 };

    CHAR strFrameType[ 64 ] = { 0 };

    qDebug("format changed Detected  \n");

    g_pMainwindow->m_nVideoWidth[i] = nVideoWidth;

    g_pMainwindow->m_nVideoHeight[i] = nVideoHeight;

    g_pMainwindow->m_bVideoIsInterleaved[i] = bVideoIsInterleaved;

    g_pMainwindow->m_dVideoFrameRate[i] = dVideoFrameRate;

    g_pMainwindow->m_nAudioChannels[i] = nAudioChannels;

    g_pMainwindow->m_nAudioBitsPerSample[i] = nAudioBitsPerSample;

    g_pMainwindow->m_nAudioSampleFrequency[i] = nAudioSampleFrequency;


    if ( nVideoInput == 0 ) { sprintf( strVideoInput, "COMPOSITE" ); }

    if ( nVideoInput == 1 ) { sprintf( strVideoInput, "SVIDEO" ); }

    if ( nVideoInput == 2 ) { sprintf( strVideoInput, "HDMI" );}

    if ( nVideoInput == 3 ) { sprintf( strVideoInput, "DVI_D" );}

    if ( nVideoInput == 4 ) { sprintf( strVideoInput, "COMPONENTS (YCBCR)" );}

    if ( nVideoInput == 5 ) { sprintf( strVideoInput, "DVI_A (RGB / VGA)" );}

    if ( nVideoInput == 6 ) { sprintf( strVideoInput, "SDI" );}

    if ( nVideoInput == 7 ) { sprintf( strVideoInput, "AUTO" );}

    if ( nAudioInput == 0 ) { sprintf( strAudioInput, "EMBEDDED_AUDIO" );}

    if ( nAudioInput == 1 ) { sprintf( strAudioInput, "LINE_IN" );}

    if ( nAudioInput == 2 ) { sprintf( strAudioInput, "SOUNDCARD_MICROPHONE" );}

    if ( nAudioInput == 3 ) { sprintf( strAudioInput, "SOUNDCARD_LINE_IN" );}

    if ( bVideoIsInterleaved == TRUE ) { nVH = nVideoHeight / 2; } else { nVH = nVideoHeight; }

    if ( bVideoIsInterleaved == TRUE ) { sprintf( strFrameType, " I " ); } else { sprintf( strFrameType, " P " ); }

    g_pMainwindow->m_str_info[ i ].sprintf("INFO : %d x %d%s @%2.3f FPS , %d CH x %d BITS x %d HZ ,  VIDEO INPUT : %s ,  AUDIO INPUT : %s"

                                                            , nVideoWidth, nVH, strFrameType, dVideoFrameRate, nAudioChannels, nAudioBitsPerSample

                                                            , nAudioSampleFrequency, strVideoInput, strAudioInput);



    return QCAP_RT_OK;
}

QRETURN on_process_video_preview_callback( PVOID pDevice, double dSampleTime, BYTE* pFrameBuffer, ULONG nFrameBufferLen, PVOID pUserData)
{
    ULONG i = (uintptr_t)(pUserData);

    return QCAP_RT_OK;
}

QRETURN on_process_audio_preview_callback( PVOID pDevice, double dSampleTime, BYTE* pFrameBuffer, ULONG nFrameBufferLen, PVOID pUserData)
{
    ULONG i = (uintptr_t)(pUserData);

    if( pFrameBuffer )
    {
        EnterCriticalSection( &g_pMainwindow->m_hNetworkServerAccessCriticalSection_audio[i] );

        if( g_pMainwindow->m_nNetworkServerState_audio[i] > 0x00000000 )
        {
            QCAP_SET_AUDIO_BROADCAST_SERVER_UNCOMPRESSION_BUFFER( g_pMainwindow->m_hNetworkServer[i], 0, pFrameBuffer, nFrameBufferLen, dSampleTime );
        }

        LeaveCriticalSection( &g_pMainwindow->m_hNetworkServerAccessCriticalSection_audio[i] );
    }

    return QCAP_RT_OK;
    }

    QRETURN on_process_hardware_encode_callback( PVOID pDevice, UINT iRecNum, double dSampleTime, BYTE * pStreamBuffer, ULONG nStreamBufferLen, BOOL bIsKeyFrame, PVOID pUserData) {

    ULONG i = (uintptr_t)(pUserData);

    if( pStreamBuffer )
    {
        EnterCriticalSection( &g_pMainwindow->m_hNetworkServerAccessCriticalSection_video[i] );

        if( g_pMainwindow->m_nNetworkServerState_video[i] > 0x00000000 )
        {
            QCAP_SET_VIDEO_BROADCAST_SERVER_COMPRESSION_BUFFER( g_pMainwindow->m_hNetworkServer[i], 0, pStreamBuffer, nStreamBufferLen, bIsKeyFrame, dSampleTime);
        }

        LeaveCriticalSection( &g_pMainwindow->m_hNetworkServerAccessCriticalSection_video[i] );
    }

    return QCAP_RT_OK;
}



MainWindow::MainWindow(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::MainWindow)
{
    ui->setupUi(this);

    this->setFixedSize(810, 800);

    this->setWindowTitle("TS over UDP");

    g_pMainwindow = this;

    ui->lineEdit_URL_1->setText(QString("udp://127.0.0.1:1000"));

    ui->lineEdit_URL_2->setText(QString("udp://127.0.0.1:1001"));

    ui->lineEdit_URL_3->setText(QString("udp://127.0.0.1:1002"));

    ui->lineEdit_URL_4->setText(QString("udp://127.0.0.1:1003"));


    for ( ULONG i = 0 ; i < 4 ; i++ ) {

        m_pDevice[i] = NULL;

        m_hNetworkServer[i] = NULL;

        m_nNetworkServerState_audio[i] = 0x00000000;

        m_nNetworkServerState_video[i] = 0x00000000;

        m_nVideoWidth[i] = 0;

        m_nVideoHeight[i] = 0;

        m_bVideoIsInterleaved[i] = FALSE;

        m_dVideoFrameRate[i] = 0.0;

        m_nAudioChannels[i] = 0;

        m_nAudioBitsPerSample[i] = 0;

        m_nAudioSampleFrequency[i] = 0;

        InitializeCriticalSection( &m_hNetworkServerAccessCriticalSection_video[i]);

        InitializeCriticalSection( &m_hNetworkServerAccessCriticalSection_audio[i]);
    }

    ui->pushBTN_Start_1->setEnabled(true);

    ui->pushBTN_Stop_1->setEnabled(false);

    ui->pushBTN_Start_2->setEnabled(true);

    ui->pushBTN_Stop_2->setEnabled(false);

    ui->pushBTN_Start_3->setEnabled(true);

    ui->pushBTN_Stop_3->setEnabled(false);

    ui->pushBTN_Start_4->setEnabled(true);

    ui->pushBTN_Stop_4->setEnabled(false);

    ui->lineEdit_TTL_1->setText("7");

    ui->lineEdit_TTL_2->setText("7");

    ui->lineEdit_TTL_3->setText("7");

    ui->lineEdit_TTL_4->setText("7");

    m_nTimerId = startTimer(1000);

    HwInitialize();

}

MainWindow::~MainWindow()
{
    HwUninitialize();

    delete ui;
}

void MainWindow::HwInitialize()
{
    //CREATE CAPTURE DEVICE

    QCAP_CREATE( "QP0203 PCI", 0, (HWND)ui->frame_1->winId(), &m_pDevice[0], TRUE);

    QCAP_CREATE( "QP0203 PCI", 1, (HWND)ui->frame_2->winId(), &m_pDevice[1], TRUE);

    QCAP_CREATE( "QP0203 PCI", 2, (HWND)ui->frame_3->winId(), &m_pDevice[2], TRUE);

    QCAP_CREATE( "QP0203 PCI", 3, (HWND)ui->frame_4->winId(), &m_pDevice[3], TRUE);

    for ( ULONG i = 0 ; i < 4 ; i++ ) {

        QCAP_REGISTER_NO_SIGNAL_DETECTED_CALLBACK( m_pDevice[i], on_process_no_signal_detected, (PVOID)i );

        QCAP_REGISTER_SIGNAL_REMOVED_CALLBACK( m_pDevice[i], on_process_signal_removed, (PVOID)i );

        QCAP_REGISTER_FORMAT_CHANGED_CALLBACK( m_pDevice[i], on_process_format_changed, (PVOID)i );

        QCAP_REGISTER_VIDEO_PREVIEW_CALLBACK( m_pDevice[i], on_process_video_preview_callback, (PVOID)i );

        QCAP_REGISTER_AUDIO_PREVIEW_CALLBACK( m_pDevice[i], on_process_audio_preview_callback, (PVOID)i );

        QCAP_REGISTER_VIDEO_HARDWARE_ENCODER_CALLBACK( m_pDevice[i], 0, on_process_hardware_encode_callback, (PVOID)i);

        QCAP_SET_VIDEO_HARDWARE_ENCODER_PROPERTY( m_pDevice[i], 0, QCAP_ENCODER_FORMAT_H264, QCAP_RECORD_MODE_CBR, 8000, 4 * 1024 * 1024, 30, 0, 0, 0, 0, 0);

        QCAP_SET_VIDEO_INPUT( m_pDevice[i], QCAP_INPUT_TYPE_SDI );

        QCAP_SET_AUDIO_INPUT( m_pDevice[i], QCAP_INPUT_TYPE_EMBEDDED_AUDIO );

        QCAP_RUN( m_pDevice[i] );
    }
}

void MainWindow::HwUninitialize()
{
    //DESTROY CAPTURE DEVICE

    on_pushBTN_Stop_1_clicked();

    on_pushBTN_Stop_2_clicked();

    on_pushBTN_Stop_3_clicked();

    on_pushBTN_Stop_4_clicked();

    for ( ULONG i = 0 ; i < 4 ; i++ ) {

        if( m_pDevice[i] ) {

            QCAP_STOP( m_pDevice[i] );

            QCAP_DESTROY( m_pDevice[i] );

            m_pDevice[i] = NULL;
        }

        DeleteCriticalSection( &m_hNetworkServerAccessCriticalSection_audio[i] );

        DeleteCriticalSection( &m_hNetworkServerAccessCriticalSection_video[i] );
    }
}

void MainWindow::on_pushBTN_Start_1_clicked()
{
    if( (m_nVideoWidth[0] == 0) || (m_nVideoHeight[0] == 0) ) { return; }

    QString URL = ui->lineEdit_URL_1->text();

    int ttl = ui->lineEdit_TTL_1->text().toInt();

    if ( ttl < 0 && ttl > 255) ttl = 7;

    QCAP_CREATE_BROADCAST_TS_OVER_UDP_SERVER(0, URL.toLatin1().data(), &m_hNetworkServer[0], NULL, 1, "", "", TRUE, 12 * 1024 * 1024, 1, 1, 4096, 4097, 256, 257, 0, 0, 0, ttl);

    QCAP_SET_VIDEO_BROADCAST_SERVER_PROPERTY( m_hNetworkServer[0], 0, QCAP_ENCODER_TYPE_HARDWARE, QCAP_ENCODER_FORMAT_H264, QCAP_COLORSPACE_TYPE_YUY2, m_nVideoWidth[0], m_nVideoHeight[0], 30, QCAP_RECORD_MODE_CBR, 8000, 4 * 1024 * 1024, 30, 0, 0, NULL, FALSE, FALSE, QCAP_BROADCAST_FLAG_FULL );

    QCAP_SET_AUDIO_BROADCAST_SERVER_PROPERTY( m_hNetworkServer[0], 0, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_AAC_ADTS, m_nAudioChannels[0], m_nAudioBitsPerSample[0], m_nAudioSampleFrequency[0] );

    QCAP_START_BROADCAST_SERVER( m_hNetworkServer[0] );

    EnterCriticalSection( &m_hNetworkServerAccessCriticalSection_audio[0] );

    m_nNetworkServerState_audio[0] = 0x00000001;

    LeaveCriticalSection( &m_hNetworkServerAccessCriticalSection_audio[0] );

    EnterCriticalSection( &m_hNetworkServerAccessCriticalSection_video[0] );

    m_nNetworkServerState_video[0] = 0x00000001;

    LeaveCriticalSection( &m_hNetworkServerAccessCriticalSection_video[0] );

    ui->pushBTN_Start_1->setEnabled(false);

    ui->pushBTN_Stop_1->setEnabled(true);
}


void MainWindow::on_pushBTN_Stop_1_clicked()
{
    if( m_hNetworkServer[0]!= NULL )
    {
        EnterCriticalSection( &m_hNetworkServerAccessCriticalSection_audio[0] );

        m_nNetworkServerState_audio[0] = 0x00000000;

        LeaveCriticalSection( &m_hNetworkServerAccessCriticalSection_audio[0] );

        EnterCriticalSection( &m_hNetworkServerAccessCriticalSection_video[0] );

        m_nNetworkServerState_video[0] = 0x00000000;

        LeaveCriticalSection( &m_hNetworkServerAccessCriticalSection_video[0] );

        QCAP_STOP_BROADCAST_SERVER( m_hNetworkServer[0] );

        QCAP_DESTROY_BROADCAST_SERVER( m_hNetworkServer[0] );

        m_hNetworkServer[0] = NULL;        
    }

    ui->pushBTN_Start_1->setEnabled(true);

    ui->pushBTN_Stop_1->setEnabled(false);
}

void MainWindow::on_pushBTN_Start_2_clicked()
{
    if( (m_nVideoWidth[1] == 0) || (m_nVideoHeight[1] == 0) ) { return; }

    QString URL = ui->lineEdit_URL_2->text();

    int ttl = ui->lineEdit_TTL_2->text().toInt();

    if ( ttl < 0 && ttl > 255) ttl = 7;

    QCAP_CREATE_BROADCAST_TS_OVER_UDP_SERVER(1, URL.toLatin1().data(), &m_hNetworkServer[1], NULL, 1, "", "", TRUE, 12 * 1024 * 1024, 1, 1, 4096, 4097, 256, 257, 0, 0, 0, ttl);

    QCAP_SET_VIDEO_BROADCAST_SERVER_PROPERTY( m_hNetworkServer[1], 0, QCAP_ENCODER_TYPE_HARDWARE, QCAP_ENCODER_FORMAT_H264, QCAP_COLORSPACE_TYPE_YUY2, m_nVideoWidth[1], m_nVideoHeight[1], 30, QCAP_RECORD_MODE_CBR, 8000, 4 * 1024 * 1024, 30, 0, 0, NULL, FALSE, FALSE, QCAP_BROADCAST_FLAG_FULL );

    QCAP_SET_AUDIO_BROADCAST_SERVER_PROPERTY( m_hNetworkServer[1], 0, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_AAC_ADTS, m_nAudioChannels[1], m_nAudioBitsPerSample[1], m_nAudioSampleFrequency[1] );

    QCAP_START_BROADCAST_SERVER( m_hNetworkServer[1] );

    pthread_mutex_lock( &m_hNetworkServerAccessCriticalSection_audio[1] );

    m_nNetworkServerState_audio[1] = 0x00000001;

    pthread_mutex_unlock( &m_hNetworkServerAccessCriticalSection_audio[1] );

    EnterCriticalSection( &m_hNetworkServerAccessCriticalSection_video[1] );

    m_nNetworkServerState_video[1] = 0x00000001;

    LeaveCriticalSection( &m_hNetworkServerAccessCriticalSection_video[1] );

    ui->pushBTN_Start_2->setEnabled(false);

    ui->pushBTN_Stop_2->setEnabled(true);
}

void MainWindow::on_pushBTN_Stop_2_clicked()
{
    if( m_hNetworkServer[1]!= NULL )
    {
        EnterCriticalSection( &m_hNetworkServerAccessCriticalSection_audio[1] );

        m_nNetworkServerState_audio[1] = 0x00000000;

        LeaveCriticalSection( &m_hNetworkServerAccessCriticalSection_audio[1] );

        EnterCriticalSection( &m_hNetworkServerAccessCriticalSection_video[1] );

        m_nNetworkServerState_video[1] = 0x00000000;

        LeaveCriticalSection( &m_hNetworkServerAccessCriticalSection_video[1] );

        QCAP_STOP_BROADCAST_SERVER( m_hNetworkServer[1] );

        QCAP_DESTROY_BROADCAST_SERVER( m_hNetworkServer[1] );

        m_hNetworkServer[1] = NULL;
    }

    ui->pushBTN_Start_2->setEnabled(true);

    ui->pushBTN_Stop_2->setEnabled(false);
}

void MainWindow::on_pushBTN_Start_3_clicked()
{
    if( (m_nVideoWidth[2] == 0) || (m_nVideoHeight[2] == 0) ) { return; }

    QString URL = ui->lineEdit_URL_3->text();

    int ttl = ui->lineEdit_TTL_3->text().toInt();

    if ( ttl < 0 && ttl > 255) ttl = 7;

    QCAP_CREATE_BROADCAST_TS_OVER_UDP_SERVER(2, URL.toLatin1().data(), &m_hNetworkServer[2], NULL, 1, "", "", TRUE, 12 * 1024 * 1024, 1, 1, 4096, 4097, 256, 257, 0, 0, 0, ttl);

    QCAP_SET_VIDEO_BROADCAST_SERVER_PROPERTY( m_hNetworkServer[2], 0, QCAP_ENCODER_TYPE_HARDWARE, QCAP_ENCODER_FORMAT_H264, QCAP_COLORSPACE_TYPE_YUY2, m_nVideoWidth[2], m_nVideoHeight[2], 30, QCAP_RECORD_MODE_CBR, 8000, 4 * 1024 * 1024, 30, 0, 0, NULL, FALSE, FALSE, QCAP_BROADCAST_FLAG_FULL );

    QCAP_SET_AUDIO_BROADCAST_SERVER_PROPERTY( m_hNetworkServer[2], 0, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_AAC_ADTS, m_nAudioChannels[2], m_nAudioBitsPerSample[2], m_nAudioSampleFrequency[2] );

    QCAP_START_BROADCAST_SERVER( m_hNetworkServer[2] );

    EnterCriticalSection( &m_hNetworkServerAccessCriticalSection_audio[2] );

    m_nNetworkServerState_audio[2] = 0x00000001;

    LeaveCriticalSection( &m_hNetworkServerAccessCriticalSection_audio[2] );

    EnterCriticalSection( &m_hNetworkServerAccessCriticalSection_video[2] );

    m_nNetworkServerState_video[2] = 0x00000001;

    LeaveCriticalSection( &m_hNetworkServerAccessCriticalSection_video[2] );

    ui->pushBTN_Start_3->setEnabled(false);

    ui->pushBTN_Stop_3->setEnabled(true);
}

void MainWindow::on_pushBTN_Stop_3_clicked()
{
    if( m_hNetworkServer[2]!= NULL )
    {
        EnterCriticalSection( &m_hNetworkServerAccessCriticalSection_audio[2] );

        m_nNetworkServerState_audio[2] = 0x00000000;

        LeaveCriticalSection( &m_hNetworkServerAccessCriticalSection_audio[2] );

        EnterCriticalSection( &m_hNetworkServerAccessCriticalSection_video[2] );

        m_nNetworkServerState_video[2] = 0x00000000;

        LeaveCriticalSection( &m_hNetworkServerAccessCriticalSection_video[2] );

        QCAP_STOP_BROADCAST_SERVER( m_hNetworkServer[2] );

        QCAP_DESTROY_BROADCAST_SERVER( m_hNetworkServer[2] );

        m_hNetworkServer[2] = NULL;
    }

    ui->pushBTN_Start_3->setEnabled(true);

    ui->pushBTN_Stop_3->setEnabled(false);
}

void MainWindow::on_pushBTN_Start_4_clicked()
{
    if( (m_nVideoWidth[3] == 0) || (m_nVideoHeight[3] == 0) ) { return; }

    QString URL = ui->lineEdit_URL_4->text();

    int ttl = ui->lineEdit_TTL_4->text().toInt();

    if ( ttl < 0 && ttl > 255) ttl = 7;

    QCAP_CREATE_BROADCAST_TS_OVER_UDP_SERVER(3, URL.toLatin1().data(), &m_hNetworkServer[3], NULL, 1, "", "", TRUE, 12 * 1024 * 1024, 1, 1, 4096, 4097, 256, 257, 0, 0, 0, ttl);

    QCAP_SET_VIDEO_BROADCAST_SERVER_PROPERTY( m_hNetworkServer[3], 0, QCAP_ENCODER_TYPE_HARDWARE, QCAP_ENCODER_FORMAT_H264, QCAP_COLORSPACE_TYPE_YUY2, m_nVideoWidth[3], m_nVideoHeight[3], 30, QCAP_RECORD_MODE_CBR, 8000, 4 * 1024 * 1024, 30, 0, 0, NULL, FALSE, FALSE, QCAP_BROADCAST_FLAG_FULL );

    QCAP_SET_AUDIO_BROADCAST_SERVER_PROPERTY( m_hNetworkServer[3], 0, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_AAC_ADTS, m_nAudioChannels[3], m_nAudioBitsPerSample[3], m_nAudioSampleFrequency[3] );

    QCAP_START_BROADCAST_SERVER( m_hNetworkServer[3] );


    EnterCriticalSection( &m_hNetworkServerAccessCriticalSection_audio[3] );

    m_nNetworkServerState_audio[3] = 0x00000001;

    LeaveCriticalSection( &m_hNetworkServerAccessCriticalSection_audio[3] );

    EnterCriticalSection( &m_hNetworkServerAccessCriticalSection_video[3] );

    m_nNetworkServerState_video[3] = 0x00000001;

    LeaveCriticalSection( &m_hNetworkServerAccessCriticalSection_video[3] );

    ui->pushBTN_Start_4->setEnabled(false);

    ui->pushBTN_Stop_4->setEnabled(true);
}

void MainWindow::on_pushBTN_Stop_4_clicked()
{
    if( m_hNetworkServer[3]!= NULL )
    {
        EnterCriticalSection( &m_hNetworkServerAccessCriticalSection_audio[3] );

        m_nNetworkServerState_audio[3] = 0x00000000;

        LeaveCriticalSection( &m_hNetworkServerAccessCriticalSection_audio[3] );

        EnterCriticalSection( &m_hNetworkServerAccessCriticalSection_video[3] );

        m_nNetworkServerState_video[3] = 0x00000000;

        LeaveCriticalSection( &m_hNetworkServerAccessCriticalSection_video[3] );

        QCAP_STOP_BROADCAST_SERVER( m_hNetworkServer[3] );

        QCAP_DESTROY_BROADCAST_SERVER( m_hNetworkServer[3] );

        m_hNetworkServer[3] = NULL;
    }

    ui->pushBTN_Start_4->setEnabled(true);

    ui->pushBTN_Stop_4->setEnabled(false);
}

void MainWindow::timerEvent( QTimerEvent *event )
{
    //qDebug("event->timerId() = %d",event->timerId());

    if( event->timerId() == m_nTimerId )
    {
        ui->m_info_1->setText( m_str_info[0] );

        ui->m_info_2->setText( m_str_info[1] );

        ui->m_info_3->setText( m_str_info[2] );

        ui->m_info_4->setText( m_str_info[3] );
    }
}

